<?php
class Upgrade { const TYPE_HOSTING = 'hosting'; const TYPE_DEDICATED_SERVER = 'dedicated_server'; const TYPE_HOSTING_ADDON = 'hosting_addon'; const TYPE_SECURITY = 'security'; const TYPE_TOOLS = 'tools'; const TYPE_INTERNET = 'internet'; const TYPE_UPLOAD_STORAGE = 'upload_storage'; const TYPE_WEBSITE = 'website'; const TYPE_MARKETING = 'marketing'; const TYPE_MINING = 'mining'; private $id; private $name; private $type; private $level; private $maxLevel; private $baseCost; private $releaseYear; private $description; private $acquired; private $effects; public function __construct($data) { $this->id = $data['id'] ?? null; $this->name = $data['name']; $this->type = $data['type']; $this->level = $data['level'] ?? 0; $this->maxLevel = $data['max_level']; $this->baseCost = $data['base_cost']; $this->releaseYear = $data['release_year']; $this->description = $data['description']; $this->acquired = $data['acquired'] ?? false; $this->effects = json_decode($data['effects'] ?? '{}', true); } public function getId() { return $this->id; } public function getName() { return $this->name; } public function getType() { return $this->type; } public function getLevel() { return $this->level; } public function getMaxLevel() { return $this->maxLevel; } public function getBaseCost() { return $this->baseCost; } public function getReleaseYear() { return $this->releaseYear; } public function getDescription() { return $this->description; } public function isAcquired() { return $this->acquired; } public function getEffects() { if (is_string($this->effects)) { return json_decode($this->effects, true) ?: []; } return $this->effects ?: []; } public function isOneTime() { return $this->maxLevel === 1; } public function calculateCost() { $multiplier = 1; if ($this->maxLevel > 1 && $this->level > 0) { $multiplier = pow(2, $this->level); } return $this->baseCost * $multiplier; } public function canUpgrade($gameYear) { if ($gameYear < $this->releaseYear) { return false; } if ($this->isOneTime() && $this->acquired) { return false; } if ($this->level >= $this->maxLevel) { return false; } return true; } public function upgrade() { if ($this->isOneTime()) { $this->acquired = true; } else { $this->level++; } } public function save($db) { if ($this->id) { $db->query( "UPDATE upgrades SET
                name = ?,
                type = ?,
                level = ?,
                max_level = ?,
                base_cost = ?,
                release_year = ?,
                description = ?,
                acquired = ?,
                effects = ?
                WHERE id = ?", [ $this->name, $this->type, $this->level, $this->maxLevel, $this->baseCost, $this->releaseYear, $this->description, $this->acquired ? 1 : 0, json_encode($this->effects), $this->id ] ); } else { $db->query( "INSERT INTO upgrades
                (name, type, level, max_level, base_cost, release_year, description, acquired, effects)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)", [ $this->name, $this->type, $this->level, $this->maxLevel, $this->baseCost, $this->releaseYear, $this->description, $this->acquired ? 1 : 0, json_encode($this->effects) ] ); $this->id = $db->lastInsertId(); } } public static function getByType($db, $type) { $result = $db->query( "SELECT * FROM upgrades WHERE type = ? ORDER BY release_year, base_cost", [$type] )->fetchAll(PDO::FETCH_ASSOC); $upgrades = []; foreach ($result as $data) { $upgrades[] = new Upgrade($data); } return $upgrades; } public static function getById($db, $id) { $result = $db->query( "SELECT * FROM upgrades WHERE id = ?", [$id] )->fetch(PDO::FETCH_ASSOC); if ($result) { return new Upgrade($result); } return null; } public static function getAll($db) { $result = $db->query( "SELECT * FROM upgrades ORDER BY type, release_year, base_cost" )->fetchAll(PDO::FETCH_ASSOC); $upgrades = []; foreach ($result as $data) { $upgrades[] = new Upgrade($data); } return $upgrades; } } 